﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Web.Business.App;
using Soneta.Web.Business.Kadry;
using System.Collections.Generic;
using Soneta.Langs;

namespace ASP {

    public partial class Badania_Okresowe_Braki : System.Web.UI.Page {

        public string Str_CultureInfo = "pl-PL";
        public string Str_Definicja = "(razem)";

        public class PrnParams: ContextBase {
    
            public PrnParams(Context context): base(context) {
            }

            DefinicjaBadaniaLekarskiego definicja;
		    [Soneta.Business.Required]
            [Caption("Definicja")]
            public DefinicjaBadaniaLekarskiego Definicja {
                get { return definicja; }
                set {
                    definicja = value;
                    OnChanged(EventArgs.Empty);
                }
            }

		    public object GetListDefinicja() {
			    return KadryModule.GetInstance(this).DefBadanLek.WgNazwy.CreateView();
		    }
        }

        DefinicjaBadaniaLekarskiego definicja;
	    PrnParams pars = null;
	
        [Context]
        public PrnParams Params {
            set {
			    pars = value;
			    definicja = value.Definicja; }
        }
    
        protected void OnContextLoad(Object sender, EventArgs args) {
            ArrayList lista = new ArrayList();
		
		    // Odczytanie listy pracowników podległych z kontekstu
		    // Metoda znajduje się we wspólnej klasie dla strony raportu
		    // Soneta.Web.UI.ReportCorePage
            Row[] rows = getRows();

		    ReportHeader1["DEFINICJA"] = definicja != null ? definicja.GetLocalizedNazwa(new System.Globalization.CultureInfo(Str_CultureInfo)) : Str_Definicja;
    
            foreach (Pracownik prc in rows) {
                bool ok = false;
                foreach (BadanieLekarskie badanie in prc.BadaniaLekarskie)
				    if ((definicja == null || definicja.ID == badanie.Definicja.ID) && badanie.Data == Date.Empty && !badanie.Anulowany) {
                        ok = true;
                        break;
                    }
                if (!ok)
                    lista.Add(prc);
            }
    
            Grid1.DataSource = lista;
        }

        private Row[] getRows() {
            //Soneta.Business.View v = Soneta.Web.Business.Kadry.Tools.GetPodwładni(dc);
            Date aktualnosc = ((ActualDate)dc.Context[typeof(ActualDate)]).Actual;
            var podwladni = KadryModule.GetInstance(dc.Context).Pracownicy.CreateView();
            Soneta.KadryPlace.Kadry.KalkulatorPodwladnych kalkulator = new Soneta.KadryPlace.Kadry.KalkulatorPodwladnych(dc.Context.Session, dc.Context.Session.Login.WebUserInstance.Host.ID);
            podwladni.Condition &= kalkulator.FiltrPodległości(FromTo.Day(aktualnosc), false);
            List<Pracownik> list = new List<Pracownik>();
            foreach (Pracownik p in podwladni)
                list.Add(p);
            return list.ToArray();
        }
    }
}
